; TEMPERATURE  AND REAL TIME DISPLAY PROGRAM WITH - FILL OUT LOG BOOK WARNING-"
; USED IN CLASSIC CARS THAT REQUIRE A LOG BOOK TO BE FILLED OUT FOR EACH DAY CAR IS USED (VicRoads Classic Car registration system)

;Clive Allan
;cstallan@bigpond.com
;24th October, 2017
;Version: Final executable

; Uses PICAXE-08M2

; conections to LCD  via PCF8574 port expander
; Real time module via i2C 

; Below show connections from i2C port expander to LCD display. 

; DB7 DB6  DB5  DB4 BL  EN  R/W RS
;  D7  D6   D5   D4 D3  D2   D1 D0

; initialisation sequence as per hitachi spec sheet
; wait for more than 40ms after Vcc rises to 2.7v

; The following are bitwise settings required to control the LCD dislay. BL=backlight, EN=Enable (pulsed high/low)
;   D7-D6- D5- D4 - D3-D2-D1-D0 
;( DB7-DB6-DB5-DB4-BL-EN-R/W-RS)
;  0   0   1   1   *  *  0  0  - ($38) Output 3 times- (note BL & EN are controlled by lcdout subroutine)
;  0   0   1   0   *  *  0  0  - ($20) MSB- Function set, 4bit interface, 2 display line 5 x 7 font (change to suit
;  0   1   0   0   *  *  0  0  - ($80) LSB- Function set, 4bit interface, 2 display line 5 x 7 font (change to suit)
;  0   0   0   0   *  *  0  0  - ($00) MSB- Entry Mode, increment automatically, no display shift (change to suit)
;  0   1   1   0   *  *  0  0  - ($60) LSB- Entry Mode, increment automatically, no display shift (change to suit)
;  0   0   0   0   *  *  0  0  - ($00) MSB- Display ON/OFF, cursor OFF, blinking of cursor
;  1   1   1   1   *  *  0  0  - ($C0) LSB- Display ON/OFF, cursor OFF, blinking of cursor
;  0   0   0   0   *  *  0  0  - ($00) MSB- Display clear
;  0   0   0   1   *  *  0  0  - ($10) LSB- Display clear
;  1   1   0   0   *  *  0  0  - ($C0) MSB -DDRAM address $40 (first character - second line
;  0   0   0   0   *  *  0  0  - ($00  LSB -DDRAM address $40 (first character - second line
;  1   0   0   0   *  *  0  0  - ($80) MSB -DDRAM address $40 (first line pos 05
;  0   0   0   0   *  *  0  0  - ($60) LSB -DDRAM address $40 (first line pos 05
; 
;note also works for 4 x 20 display. character addresses as follows
; 1.....20
; 41....60
; 21....40
; 61....80

;Registers
symbol count1 	= b0
symbol se	  	= b20
symbol mi   	= b21
symbol hr	 	= b22
symbol dy   	= b23
symbol dt	  	= b24
symbol mt 		= b25
symbol yr   	= b26 

; IC2 PCF858574 address
;SYMBOL Addr8574 = %001001110 ;($4E - PCF858574T)- two versions of i2c LCD interface board
SYMBOL Addr8574 = %01111110 ;($7E -PCF858574AT)
SYMBOL Addr3231 = %11010000 ;reatime clock address

main: pause 100 'allow LCD to settle'
	i2cslave Addr8574, i2cslow, i2cbyte
	
;Initialize LCD display - Don't change!
init1: 	
  	lookup count1,($38,$38,$38,$20,$20,$80,$00,$60,$00,$C0,$00,$10),b1
  	gosub lcdout
  	inc count1
  	if count1 < 12 then init1
	count1=0
	pause 100
	
;Alert for logbook fillin
	
	;check if first time powered up for a particular day
	;read real time data, compare with last value stored in eeprom (date/month/year)
	;If different must be first time powered up for day - warn to fill in log book
	
	i2cslave Addr3231, i2cslow, i2cbyte
	pause 100
	hi2Cin $0,(se,mi,hr,dy,dt,mt,yr)			; read sec/min/hours/day/date/month/year
	read 0,b0
	if b0<>dt then vislog
	read 1,b0
	if b0<>mt then vislog
	read 2,b0
	if b0<>yr then vislog



repeat2:
	count1=0
repeat8:
	lookup count1, ("Temp "),b3
	gosub charstg
	inc count1
	if count1 < 5 then repeat8
	
;Change time and date check

ddrepeat:
;check if program button has been pushed
	if pinc.3<>0 then prog2	; yes, go to programming routine
	gosub setup
	
;Show updated temperature routine starts here 
	
prog2:count1=0
ddrepeat1:
	lookup count1,($80,$60),b1 ;always start from location $0B top line
  	gosub lcdout
  	inc count1
  	if count1 < 2 then ddrepeat1
	pause 100
	
readtemp C.4,b1
	if b1 > 127 then negtemp
	bintoascii b1,b7,b8,b9
	if b8<>$30 then readtemp1
	b8=$20  				;suppress leading zero from output
readtemp1:
	b3=b8
	gosub charstg
	b3=b9
	gosub charstg
	gosub temper			;goto read and display current time routine
	goto ddrepeat
		
negtemp:	

	let b1=b1-128
	bintoascii b1,b7,b8,b9
	if b8<>$30 then negtemp1
	b8="-"  				;suppress leading zero from output
negtemp1:
	b3=b8
	gosub charstg
	b3=b9
	gosub charstg
	goto ddrepeat
	

;subroutines

;lcdout
;IN: B1 (contents to LCD command and char registers
;OUT None - note B1&B2 content not preserved on return

;this subroutine accepts data in b1 register and outputs to LCD i2c command registry
;note b1 register content changes after execution of hi2cout command
;it does not manipute the data other than toggle bit2 (LCD EN)which is used by the LCD to accept data
;it also OR's bit 3 (BL) to ensure backlight LED remains on.
;when operating in 4 bit mode 2 calls are required and MSB & LSB nibbles need to set up before routine called

lcdout:i2cslave Addr8574, i2cslow, i2cbyte 
	 b1 = b1 | %00001100 ;Pulse EN high, keep BL high
	 b2=b1
	 hi2cout (b1)
	 b2 = b2 & %11111011 ;Pulse EN low, keep BL high
	 hi2cout (b2)
	 return

;charstg
;IN    B3 (contents is ASCII format to LCD character gen for display)
;OUT   None - Note B1,B3,B4 are not preserved on return;
;      Note 4 bit operation requires MSB (4 bit) to be sent then LSB (4 bit) is bit shifted 4 to left (i.e. becomes MSB) and is sent (LCD ignores D0-D3 if 4bit operation

charstg:
	b4=b3
	b3 = b3 & %11110000
 	b1 = b3 | %00000001
	gosub lcdout
	b4 = b4 * 16
	b4 = b4 & %11110000
	b1 = b4 | %00000001
	gosub lcdout
	return
	
;temper 
;IN - None
;OUT - B1 - (cursor location, B3 - time (ASCII)  
 temper: ;routine to read real time clock
 
 	i2cslave Addr3231, i2cslow, i2cbyte
	pause 100
	hi2Cin $0,(b1,b2,b3)		; read sec/min/hours
	b4=b3 & %00011111			; only use bit0->bit5
	b10=b3 & %00100000		; AM=0, PM=1 (B9)
	
;The following line looks for 12.00am from real tiime clock. ie, going to next day. Turns on log book reminder if trus.
;Comment this line out if you don't want the clock to prompt at 12.00am
	if b10=0 and b4= %00010010 and b2=00 and b1<%00000100 then vislogrun10 
	
;Continues normally if not 12.00am to update LCD time display 

	bcdtoascii b2,b5,b6 'minutes
	bcdtoascii b4,b7,b8 'hours
	if b7 <> $30 then temper1
	b7 = $20 ;suppress leading zero
temper1:
	i2cslave Addr8574, i2cslow, i2cbyte 'return to temp address
	count1=0
ddrepeat2:
	gosub clrdisbotleft
repeat3:
	lookup count1, ("Time "),b3
	gosub charstg
	inc count1
	if count1 < 5 then repeat3
	b3=b7
	gosub charstg
	b3=b8
	gosub charstg
	b3=":"
	gosub charstg
	b3=b5
	gosub charstg
	b3=b6
	gosub charstg
	if b10=0 then repeat5
	
	count1=0
repeat4:lookup count1, (" PM"),b3
	gosub charstg
	inc count1
	if count1 < 3 then repeat4
	return
	
repeat5:	count1=0
repeat6:lookup count1, (" AM"),b3
	gosub charstg
	inc count1
	if count1 < 3 then repeat6
	return
	
	;*****************************************************
	;set real time routine
	;*****************************************************
	
;This routine is involked if the user holds down the program button for approx 4 secs.
;Because no hardware interupt is available it polls through date/time settings
;When a particular display is shown the user has approx 1 sec to push the buttom to increment the shown value
;Holding the button down will auto increment the value shown. Note that when the user finally releases the button the 
;value can sometimes increment one more time. This is a shortcoming of using polling.

	
setup:
	
	pause 3000
	if pinc.3=0 then setup99
	return
	

setup99:
	count1=0
prog5:
	gosub clrdistopleft
prog4rep:
	lookup count1, ("SET TIME & DATE: "),b3
	gosub charstg
	inc count1
	if count1 < 16 then prog4rep 
	count1=0
prog5rep:
	gosub clrdisbotleft
prog55rep:
	read 2,b16 ;read current year
	bcdtoascii b16,b17,b18
prog58rep:
	lookup count1, ("YEAR 20",b17,b18),b3
	gosub charstg
	inc count1
	if count1 < 9 then prog58rep
	for w5 = 0 to 500
	if pinc.3=0 then prg56rep:
	next w5
	count1=0
	goto prog70rep
	
prg56rep:
	read 2,b16; read current year
	b17=b16/16*$FA + b16 	;convert to BIN
	b17=b17+1			;inc value, ie increment year
	if b17=51 then prg57reg	;upper value year 2050, then reset to 2017
prg58reg:	
	b16=b17/10*6 + B17	;convert back to BCD
	write 2,b16
	pause 200
	count1=0
	goto prog5rep
prg57reg:
	b17=17
	goto prg58reg
	
	
;month	
prog70rep:
	gosub clrdisbotleft
prog71rep:
	read 1,b16 ;read current month
	bcdtoascii b16,b17,b18
	lookup count1, ("MONTH  ",b17,b18),b3
	gosub charstg
	inc count1
	if count1 < 9 then prog71rep
	for w5 = 0 to 500
	if pinc.3=0 then prg72rep:
	next w5
	count1=0
	goto prog100rep ;go to day
prg72rep:
	read 1,b16; read current month
	b17=b16/16*$FA + b16 	;convert to BIN
	b17=b17+1			;inc value, ie increment month
	if b17=13 then prg73reg	;upper value month12, then reset to 2017
prg74reg:	
	b16=b17/10*6 + B17	;convert back to BCD
	write 1,b16
	pause 200
	count1=0
	goto prog70rep
prg73reg:
	b17=01
	goto prg74reg
	
;day


prog100rep:
	gosub clrdisbotleft
prog101rep:
	read 0,b16 ;read current month
	bcdtoascii b16,b17,b18
	lookup count1, ("DATE   ",b17,b18),b3
	gosub charstg
	inc count1
	if count1 < 9 then prog101rep
	for w5 = 0 to 500
	if pinc.3=0 then prg102rep:
	next w5
	count1=0
	goto ampm00

prg102rep:
	read 0,b16; read current month
	b17=b16/16*$FA + b16 	;convert to BIN
	b17=b17+1			;inc value, ie increment day
	if b17=32 then prg103rep	;upper value day=31, then reset to 2017
prg104rep:	
	b16=b17/10*6 + B17	;convert back to BCD
	write 0,b16
	pause 200
	count1=0
	goto prog100rep
prg103rep:
	b17=01
	goto prg104rep
	
;AM/PM
ampm00:
	i2cslave Addr3231, i2cslow, i2cbyte
	pause 100
	hi2Cin $0,(b1,b2,b3)			; read sec/min/hours
	write 3,b3					; store temp value - will only store am/pm indicator
	write 4,b2
	write 5,b1
	write 6,b3					; stores full hour 
ampm01:
	i2cslave Addr8574, i2cslow, i2cbyte 'return to temp address
	read 3,b15
ampm02:
	gosub clrdisbotleft
ampm03:
	lookup count1, ("Time "),b3
	gosub charstg
	inc count1
	if count1 < 5 then ampm03
	count1=0
							;test for current time AM/PM?
	b15=b15 & %00100000			; AM=0, PM=1 
ampm030:
	if b15=%0000000 then ampm05
	count1=0
ampm04:
	count1=0
ampm040:
	lookup count1, ("  PM"),b3
	gosub charstg
	inc count1
	if count1 < 4 then ampm040
	for w5 = 0 to 500
	if pinc.3=0 then ampm041
	next w5
	b15=b15 | %01100000			; set for 12 hour clock
	write 3,b15
	goto hour00 		
ampm041:
	b15=%0000000
	count1=0
	goto ampm02
	goto hour00

ampm05:count1=0
ampm050:
	lookup count1, ("  AM"),b3
	gosub charstg
	inc count1
	if count1 < 4 then ampm050	
	for w5 = 0 to 500
	if pinc.3=0 then ampm06
next w5
	b15=b15 & %00100000			; only store am/pm indicator
	b15=b15 | %01000000			; set for 12 hour clock
	write 3,b15
	goto hour00			;get out
ampm06:
	b15= %00100000
	count1=0
	goto ampm02
	
	;Hour
	
hour00: count1=0
hour01:
	gosub clrdisbotleft
hour02:
	read 6,b16 							;read current hour
	b16=b16 & %00011111					;only interested in time
	bcdtoascii b16,b17,b18
	lookup count1, ("Hour   ",b17,b18),b3
	gosub charstg
	inc count1
	if count1 < 9 then hour02
	for w5 = 0 to 500
	if pinc.3=0 then hour03:
	next w5
	count1=0
	goto min01

hour03:
	b17=b16/16*$FA + b16 	;convert to BIN
	b17=b17+1			;inc value, ie increment day
	if b17=13 then hour04	;upper value hour 12 =, then reset to 1
hour05:	
	b16=b17/10*6 + B17	;convert back to BCD
	write 6,b16
	pause 200
	count1=0
	goto hour01
hour04:
	b17=01
	goto hour05
	
	;minutes
	
min00: count1=0
min01:
	gosub clrdisbotleft
min02:
	read 4,b16 							;read current minute
	bcdtoascii b16,b17,b18
	lookup count1, ("Minute   ",b17,b18),b3
	gosub charstg
	inc count1
	if count1 < 11 then min02
	for w5 = 0 to 500
	if pinc.3=0 then min03:
	next w5
	count1=0
	goto storetime

min03:
	b17=b16/16*$FA + b16 	;convert to BIN
	b17=b17+1			;inc value, ie increment day
	if b17=60 then min04	;upper value min 59 =, then reset to 0
min05:	
	b16=b17/10*6 + B17	;convert back to BCD
	write 4,b16
	pause 200
	count1=0
	goto min01
min04:
	b17=00
	goto min05
	
;UPDATE ALL CHANGES AND LOAD REAL TIME CLOCK
	;loc 2 - year
	;loc 1 - month
	;loc 0 - day
	;loc 3 -  AM/PM indicator
	;loc 6 - hour
	;loc 4 - minute
	
storetime:
	
	b0=00				;always load zero seconds
	read 4,b1			;load minutes
	read 3,b7
	read 6,b2
	b2=b2 & %00011111		;only hours
	b2=b2+b7			;add 12 hour clock and AM or PM indicator
	b3=1				;make day always 1
	read 0,b4			;date
	read 1,b5			;month
	read 2,b6			;year
	i2cslave Addr3231, i2cslow, i2cbyte
	pause 100
	hi2cout 0,(b0,b1,b2,b3,b4,b5,b6)
	pause 500
	i2cslave Addr8574, i2cslow, i2cbyte 'return to display address
	
	
	
	;MAIN RETURN FROM SETUP
prog90rep:
	pause 3000
	count1=0
prog6rep:
	gosub clrdistopleft
repeat9:
	lookup count1, ("Temp "),b3
	gosub charstg
	inc count1
	if count1 < 5 then repeat9
	return
	
; The subroutine is activated when the stored yr/mth/day is different to the real time clock on powerup. i.e. the car has been started on a new day. It is also activated if the clock rolls around to 12.00am (again, a new day). It does nothing more than flash a reminder to fill in the logbook and will continue this until the user breifly pushes the program button. When pushed it updates the stored yr/mth/day value to current. Subsequent powerups during the day td not activate this routine
vislogrun00:
	gosub clrdistopleft
vislog:
vislog1:
	lookup count1, ("FILL IN LOGBOOK"),b3
	gosub charstg
	inc count1
	if count1 < 15 then vislog1
	for w5 = 0 to 500
	if pinc.3=0 then vislog3
	next w5
	count1=0
vislog2:
	gosub clrdistopleft
	for w5 = 0 to 200
	if pinc.3=0 then vislog3
	next w5
	goto vislog

vislog3:
	pause 500
	write 0,dt		;date
	write 1,mt		;month
	write 2,yr		;year
	count1=0
vislog4:
	gosub clrdistopleft
	goto repeat2

;This routine is required to update day/month/year from realtime clock when unit is powered and ticks over 12.00am
vislogrun10:
	pause 500	;delay required for realtime clock to update its registers befor reading.
	i2cslave Addr3231, i2cslow, i2cbyte
	pause 100
	hi2Cin $0,(se,mi,hr,dy,dt,mt,yr)			; read sec/min/hours/day/date/month/year
	write 0,dt
	write 1,mt
	write 2,yr
	goto vislogrun00
	
;Subroutine  - clrdistopleft
;clear diplay and return to top left

clrdistopleft:
	count1=0
clrdistopleft1:
	lookup count1,($00,$10),b1 ;clear display and start from top left
  	gosub lcdout
  	inc count1
  	if count1 < 2 then clrdistopleft1
	pause 100
	count1=0
	return
	
;Subroutine  - clrdisbotleft
;clear diplay and return to bottom left
clrdisbotleft:
	count1=0
clrdisbotleft1:
	lookup count1,($C0,$00),b1 ;clear display and start from bottom left
  	gosub lcdout
  	inc count1
  	if count1 < 2 then clrdisbotleft1
	pause 100
	count1=0
	return
	
	
 

